const stripe = require('stripe')(`sk_test_51RiDcgQN8X8zlq0XfIQNk2c8phbTQfcwiyt5VPoZj7UAGyKvpxvmgjBCV0j78sJyTyxpee0ksSUeOGqirhrWW8UB00PZlI75uS`);

class StripeBillProviders {
  constructor() {
    this.stripe = stripe;
  }

  // Get available bill providers from your platform's catalog
  async getBillProviders(country, serviceType = null) {
    try {
      console.log('🌍 Fetching bill providers for:', { country, serviceType });
      
      // Map countries to Stripe country codes
      const countryMap = {
        'NGN': 'ng',
        'USD': 'us', 
        'GBP': 'gb'
      };
      
      const stripeCountry = countryMap[country] || 'us';
      
      // In a real implementation, you would:
      // 1. Fetch bill providers from your database
      // 2. Or fetch from a Stripe product catalog
      // 3. Or fetch from an external API
      
      // For now, return mock providers based on country
      const mockProviders = this.getMockProviders(country, serviceType);
      
      console.log('✅ Found providers:', mockProviders.length);
      
      return {
        success: true,
        data: mockProviders
      };
      
    } catch (error) {
      console.error('💥 Error fetching bill providers:', error);
      throw {
        message: error.message || 'Failed to fetch bill providers',
        code: error.code,
        originalError: error
      };
    }
  }

  // Get mock providers based on country and service type
  getMockProviders(country, serviceType) {
    const providers = {
      'NGN': {
        'electricity': [
          { id: 'ekedc_ng', name: 'Eko Electricity (EKEDC)', currency: 'NGN', country: 'NGN', serviceType: 'electricity', code: 'EKEDC' },
          { id: 'ikedc_ng', name: 'Ikeja Electric (IKEDC)', currency: 'NGN', country: 'NGN', serviceType: 'electricity', code: 'IKEDC' },
          { id: 'aedc_ng', name: 'Abuja Electricity (AEDC)', currency: 'NGN', country: 'NGN', serviceType: 'electricity', code: 'AEDC' },
          { id: 'kaedc_ng', name: 'Kano Electricity (KAEDC)', currency: 'NGN', country: 'NGN', serviceType: 'electricity', code: 'KAEDC' },
          { id: 'phedc_ng', name: 'Port Harcourt Electricity (PHEDC)', currency: 'NGN', country: 'NGN', serviceType: 'electricity', code: 'PHEDC' }
        ],
        'cable_tv': [
          { id: 'dstv_ng', name: 'DSTV', currency: 'NGN', country: 'NGN', serviceType: 'cable_tv', code: 'DSTV' },
          { id: 'gotv_ng', name: 'GOtv', currency: 'NGN', country: 'NGN', serviceType: 'cable_tv', code: 'GOTV' },
          { id: 'startimes_ng', name: 'StarTimes', currency: 'NGN', country: 'NGN', serviceType: 'cable_tv', code: 'STARTIMES' },
          { id: 'tstv_ng', name: 'TSTV', currency: 'NGN', country: 'NGN', serviceType: 'cable_tv', code: 'TSTV' }
        ],
        'internet': [
          { id: 'mtn_broadband_ng', name: 'MTN Broadband', currency: 'NGN', country: 'NGN', serviceType: 'internet', code: 'MTN' },
          { id: 'airtel_broadband_ng', name: 'Airtel Broadband', currency: 'NGN', country: 'NGN', serviceType: 'internet', code: 'AIRTEL' },
          { id: 'glo_broadband_ng', name: 'Glo Broadband', currency: 'NGN', country: 'NGN', serviceType: 'internet', code: 'GLO' },
          { id: '9mobile_broadband_ng', name: '9mobile Broadband', currency: 'NGN', country: 'NGN', serviceType: 'internet', code: '9MOBILE' }
        ],
        'water': [
          { id: 'lagos_water', name: 'Lagos Water Corporation', currency: 'NGN', country: 'NGN', serviceType: 'water', code: 'LWC' },
          { id: 'lagos_water_ng', name: 'Lagos Water Corporation', currency: 'NGN', country: 'NGN', serviceType: 'water', code: 'LWC' },
          { id: 'abuja_water', name: 'Abuja Water Board', currency: 'NGN', country: 'NGN', serviceType: 'water', code: 'AWB' },
          { id: 'abuja_water_ng', name: 'Abuja Water Board', currency: 'NGN', country: 'NGN', serviceType: 'water', code: 'AWB' },
          { id: 'kano_water', name: 'Kano Water Board', currency: 'NGN', country: 'NGN', serviceType: 'water', code: 'KWB' },
          { id: 'kano_water_ng', name: 'Kano Water Board', currency: 'NGN', country: 'NGN', serviceType: 'water', code: 'KWB' }
        ],
        'streaming': [
          { id: 'netflix_ng', name: 'Netflix Nigeria', currency: 'NGN', country: 'NGN', serviceType: 'streaming', code: 'NETFLIX' },
          { id: 'spotify_ng', name: 'Spotify Nigeria', currency: 'NGN', country: 'NGN', serviceType: 'streaming', code: 'SPOTIFY' },
          { id: 'youtube_ng', name: 'YouTube Premium Nigeria', currency: 'NGN', country: 'NGN', serviceType: 'streaming', code: 'YOUTUBE' },
          { id: 'apple_ng', name: 'Apple Music Nigeria', currency: 'NGN', country: 'NGN', serviceType: 'streaming', code: 'APPLE' }
        ]
      },
      'USD': {
        'electricity': [
          { id: 'conedison_us', name: 'ConEdison (New York)', currency: 'USD', country: 'USD', serviceType: 'electricity', code: 'CONED' },
          { id: 'pge_us', name: 'PG&E (California)', currency: 'USD', country: 'USD', serviceType: 'electricity', code: 'PGE' },
          { id: 'comed_us', name: 'ComEd (Illinois)', currency: 'USD', country: 'USD', serviceType: 'electricity', code: 'COMED' }
        ],
        'cable_tv': [
          { id: 'netflix_us', name: 'Netflix US', currency: 'USD', country: 'USD', serviceType: 'cable_tv', code: 'NETFLIX' },
          { id: 'hulu_us', name: 'Hulu US', currency: 'USD', country: 'USD', serviceType: 'cable_tv', code: 'HULU' },
          { id: 'disney_us', name: 'Disney+ US', currency: 'USD', country: 'USD', serviceType: 'cable_tv', code: 'DISNEY' }
        ],
        'internet': [
          { id: 'comcast_us', name: 'Comcast', currency: 'USD', country: 'USD', serviceType: 'internet', code: 'COMCAST' },
          { id: 'verizon_us', name: 'Verizon', currency: 'USD', country: 'USD', serviceType: 'internet', code: 'VERIZON' }
        ]
      },
      'GBP': {
        'electricity': [
          { id: 'british_gas_gb', name: 'British Gas', currency: 'GBP', country: 'GBP', serviceType: 'electricity', code: 'BRITISH_GAS' },
          { id: 'edf_gb', name: 'EDF Energy UK', currency: 'GBP', country: 'GBP', serviceType: 'electricity', code: 'EDF' },
          { id: 'eon_gb', name: 'E.ON UK', currency: 'GBP', country: 'GBP', serviceType: 'electricity', code: 'EON' }
        ],
        'cable_tv': [
          { id: 'netflix_gb', name: 'Netflix UK', currency: 'GBP', country: 'GBP', serviceType: 'cable_tv', code: 'NETFLIX' },
          { id: 'spotify_gb', name: 'Spotify UK', currency: 'GBP', country: 'GBP', serviceType: 'cable_tv', code: 'SPOTIFY' },
          { id: 'bbc_gb', name: 'BBC iPlayer', currency: 'GBP', country: 'GBP', serviceType: 'cable_tv', code: 'BBC' }
        ],
        'internet': [
          { id: 'bt_gb', name: 'BT Broadband', currency: 'GBP', country: 'GBP', serviceType: 'internet', code: 'BT' },
          { id: 'sky_gb', name: 'Sky Broadband', currency: 'GBP', country: 'GBP', serviceType: 'internet', code: 'SKY' }
        ]
      }
    };

    // Default to NGN if no country specified
    const targetCountry = country || 'NGN';
    
    if (serviceType) {
      return providers[targetCountry]?.[serviceType] || [];
    } else {
      // Return all providers for the country
      const allProviders = [];
      Object.values(providers[targetCountry] || {}).forEach(serviceProviders => {
        allProviders.push(...serviceProviders);
      });
      return allProviders;
    }
  }

  // Get provider details
  async getProviderDetails(providerId) {
    try {
      console.log('🔍 Fetching provider details:', providerId);
      
      // In a real implementation, fetch from your database
      const mockProviders = this.getMockProviders('NGN', null)
        .concat(this.getMockProviders('USD', null))
        .concat(this.getMockProviders('GBP', null));
      
      const provider = mockProviders.find(p => p.id === providerId);
      
      if (!provider) {
        throw new Error('Provider not found');
      }
      
      return {
        success: true,
        data: provider
      };
      
    } catch (error) {
      console.error('💥 Error fetching provider details:', error);
      throw {
        message: error.message || 'Failed to fetch provider details',
        code: error.code,
        originalError: error
      };
    }
  }

  // Create a payment intent through YOUR platform
  async createPlatformPaymentIntent(providerId, amount, currency, customerNumber) {
    try {
      console.log('💰 Creating platform payment intent:', { providerId, amount, currency, customerNumber });
      
      // Create payment intent through YOUR Stripe account
      const paymentIntent = await this.stripe.paymentIntents.create({
        amount: amount * 100, // Convert to cents
        currency: currency.toLowerCase(),
        payment_method_types: ['card'],
        metadata: {
          provider_id: providerId,
          customer_number: customerNumber,
          bill_type: 'utility_payment',
          platform_payment: 'true'
        }
      });
      
      return {
        success: true,
        data: {
          paymentIntentId: paymentIntent.id,
          clientSecret: paymentIntent.client_secret,
          amount: paymentIntent.amount,
          currency: paymentIntent.currency,
          status: paymentIntent.status
        }
      };
      
    } catch (error) {
      console.error('💥 Error creating platform payment intent:', error);
      throw {
        message: error.message || 'Failed to create payment intent',
        code: error.code,
        originalError: error
      };
    }
  }

  // Verify customer with provider (mock implementation)
  async verifyCustomerWithProvider(providerId, customerNumber) {
    try {
      console.log('🔍 Verifying customer with provider:', { providerId, customerNumber });
      
      // Mock verification - in real implementation, call provider's API
      const isValid = customerNumber.length >= 6;
      
      return {
        success: true,
        data: {
          isValid,
          customerName: isValid ? `Customer ${customerNumber.slice(-4)}` : null,
          customerNumber,
          providerId
        }
      };
      
    } catch (error) {
      console.error('💥 Error verifying customer:', error);
      throw {
        message: error.message || 'Failed to verify customer',
        code: error.code,
        originalError: error
      };
    }
  }
}

module.exports = StripeBillProviders; 